<?php
class UsersAdmin
{
  private $dbo = null;
  
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  
  function getQuerySingleResult($query)
  {
    //Brak obiektu $dbo
    if(!$this->dbo) return false;
    
    //Wykonanie zapytania.
    if(!$result = $this->dbo->query($query)){
      //echo 'Wyst?pi? b??d (getQuerySingleResult): nieprawid?owe zapytanie...';
      return false;
    }
    if($row = $result->fetch_row()){
      //Zwr?cenie wyniku.
      return $row[0];
    }
    else{
      //Brak wynik?w zapytania.
      return false;
    }
  }

  function showList($limit)
  {
    if(!$this->dbo){
      echo 'Lista u?ytkownik?w nie jest dost?pna.';
      return;
    }
    
    //Odczytanie parametru page
    if(isset($_GET['page'])){
      $page = intval($_GET['page']);
    }
    else{
      $page = 0;
    }
    
    //Okre?lenie ca?kowitej liczby wierszy w tabeli Users
    $query = "SELECT COUNT(*) FROM Users";
    $rowsCount = (int) $this->getQuerySingleResult($query);
    
    //Obliczenie ca?kowitej liczby stron z wynikami
    $pages = ceil($rowsCount / $limit);
    
    if($page < 0 || $page >= $pages) $page = 0;
    
    $offset = $page * $limit;
    
    //Zapytanie pobieraj?ce wyniki dla bie??cej strony
    $query = "SELECT Id, Nazwa, Imie, Nazwisko, Email "
           . "FROM Users LIMIT $offset, $limit";

    if(!$users = $this->dbo->query($query)){
      return;
    }
    include 'templates/usersList.php';
  }
}
?>